// OpenGL FrameworkView.cpp : Implementierung der Klasse COpenGLFrameworkView
//

#include "stdafx.h"
#include "OpenGL Framework.h"

#include "OpenGL FrameworkDoc.h"
#include "OpenGL FrameworkView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ID for the game engine timer
#define ID_ENGINE_TIMER 1

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkView

IMPLEMENT_DYNCREATE(COpenGLFrameworkView, CView)

BEGIN_MESSAGE_MAP(COpenGLFrameworkView, CView)
	//{{AFX_MSG_MAP(COpenGLFrameworkView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_TIMER()
	ON_WM_RBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkView Konstruktion/Destruktion

COpenGLFrameworkView::COpenGLFrameworkView()
{
	// ZU ERLEDIGEN: Hier Code zur Konstruktion einfgen,

	// Init variables
	m_hGLContext = NULL;
	m_GLPixelIndex = 0;
	m_MouseCapture = TRUE;

	// Mouse is intially captured; Cursor isn't visible
	ShowCursor(FALSE);
}

COpenGLFrameworkView::~COpenGLFrameworkView()
{
}

BOOL COpenGLFrameworkView::PreCreateWindow(CREATESTRUCT& cs)
{
	// ZU ERLEDIGEN: ndern Sie hier die Fensterklasse oder das Erscheinungsbild, indem Sie
	//  CREATESTRUCT cs modifizieren.
	
    cs.style |= (WS_CLIPCHILDREN | WS_CLIPSIBLINGS);
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkView Zeichnen

void COpenGLFrameworkView::OnDraw(CDC* pDC)
{
	COpenGLFrameworkDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// ZU ERLEDIGEN: Hier Code zum Zeichnen der ursprnglichen Daten hinzufgen
}

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkView Diagnose

#ifdef _DEBUG
void COpenGLFrameworkView::AssertValid() const
{
	CView::AssertValid();
}

void COpenGLFrameworkView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

COpenGLFrameworkDoc* COpenGLFrameworkView::GetDocument() // Die endgltige (nicht zur Fehlersuche kompilierte) Version ist Inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(COpenGLFrameworkDoc)));
	return (COpenGLFrameworkDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// COpenGLFrameworkView Nachrichten-Handler

BOOL COpenGLFrameworkView::SetWindowPixelFormat(HDC hDC)
{
	PIXELFORMATDESCRIPTOR pixelDesc;

    pixelDesc.nSize             = sizeof(PIXELFORMATDESCRIPTOR);
    pixelDesc.nVersion          = 1;
    pixelDesc.dwFlags           = PFD_DRAW_TO_WINDOW | 
                                  PFD_SUPPORT_OPENGL | 
                                  PFD_DOUBLEBUFFER | 
                                  PFD_STEREO_DONTCARE;  
    pixelDesc.iPixelType        = PFD_TYPE_RGBA;
    pixelDesc.cColorBits        = 16;
    pixelDesc.cRedBits          = 8;
    pixelDesc.cRedShift         = 16;
    pixelDesc.cGreenBits        = 8;
    pixelDesc.cGreenShift       = 8;
    pixelDesc.cBlueBits         = 8;
    pixelDesc.cBlueShift        = 0;
    pixelDesc.cAlphaBits        = 0;
    pixelDesc.cAlphaShift       = 0;
    pixelDesc.cAccumBits        = 64;    
    pixelDesc.cAccumRedBits     = 16;
    pixelDesc.cAccumGreenBits   = 16;
    pixelDesc.cAccumBlueBits    = 16;
    pixelDesc.cAccumAlphaBits   = 0;
    pixelDesc.cDepthBits        = 16;
    pixelDesc.cStencilBits      = 0;
    pixelDesc.cAuxBuffers       = 0;
    pixelDesc.iLayerType        = PFD_MAIN_PLANE;
    pixelDesc.bReserved         = 0;
    pixelDesc.dwLayerMask       = 0;
    pixelDesc.dwVisibleMask     = 0;
    pixelDesc.dwDamageMask      = 0;

    m_GLPixelIndex = ChoosePixelFormat( hDC, &pixelDesc);
    if (m_GLPixelIndex==0) // Let's choose a default index.
    {
        m_GLPixelIndex = 1;    
        if (DescribePixelFormat(hDC, m_GLPixelIndex,
            sizeof(PIXELFORMATDESCRIPTOR), &pixelDesc)==0)
        {
            return FALSE;
        }
    }

    if (SetPixelFormat( hDC, m_GLPixelIndex, &pixelDesc)==FALSE)
    {
        return FALSE;
    }

	// Set engine timer
	SetTimer(ID_ENGINE_TIMER, 1, NULL);

    return TRUE;
}

int COpenGLFrameworkView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    HWND hWnd = GetSafeHwnd();
    HDC hDC = ::GetDC(hWnd);

    if (SetWindowPixelFormat(hDC)==FALSE)
        return 0;

    if (CreateViewGLContext(hDC)==FALSE)
        return 0;

    return 0;
}

BOOL COpenGLFrameworkView::CreateViewGLContext(HDC hDC)
{
	m_hGLContext = wglCreateContext(hDC);
	if (m_hGLContext == NULL)
	{
		return FALSE;
	}

	if (wglMakeCurrent(hDC, m_hGLContext)==FALSE)
	{
		return FALSE;
	}

	return TRUE;
}

void COpenGLFrameworkView::OnDestroy() 
{
	if(wglGetCurrentContext()!=NULL) 
    {
        // make the rendering context not current
        wglMakeCurrent(NULL, NULL) ;
    }
    
    if (m_hGLContext!=NULL)
    {
        wglDeleteContext(m_hGLContext);
        m_hGLContext = NULL;
    }

    // Now the associated DC can be released.
    CView::OnDestroy(); 
}

void COpenGLFrameworkView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// Viewport + Projektionsmatrix initialisieren

	GLsizei width, height;
	GLdouble aspect;

	width = cx;
	height = cy;

	if (cy==0)
		aspect = (GLdouble)width;
	else
		aspect = (GLdouble)width/(GLdouble)height;

	glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(80, aspect, 0.0007, 6.5);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glDrawBuffer(GL_BACK);

	// Pass window size to Document
	COpenGLFrameworkDoc* pDoc = GetDocument();
	pDoc->m_ViewportWidth = cx;
	pDoc->m_ViewportHeight = cy;
}

void COpenGLFrameworkView::OnPaint() 
{
	CPaintDC dc(this);   // device context for painting
	
	// Render scene and swap buffers
    COpenGLFrameworkDoc* pDoc = GetDocument();
    pDoc->RenderScene();
	SwapBuffers(dc.m_ps.hdc);

	// Kein Aufruf von CView::OnPaint() fr Zeichnungsnachrichten
}

void COpenGLFrameworkView::OnMouseMove(UINT nFlags, CPoint point) 
{
	m_Mouse.x = point.x;		
	m_Mouse.y = point.y;

	CView::OnMouseMove(nFlags, point);
}

BOOL COpenGLFrameworkView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	
	return TRUE; // OpenGL will erase the background
}

void COpenGLFrameworkView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen

	// Set class internal key state for the pressed key
	m_Keys[nChar] = TRUE;

	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void COpenGLFrameworkView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	
	// Set class internal key state for the pressed key
	m_Keys[nChar] = FALSE;

	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void COpenGLFrameworkView::OnTimer(UINT nIDEvent) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen

	// Call engine loop
	Engine();

	CView::OnTimer(nIDEvent);
}

void COpenGLFrameworkView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen

	// Toggle capturing of the mouse
	if (m_MouseCapture == TRUE)
	{
		m_MouseCapture = FALSE;
		ShowCursor(TRUE);
	}
	else
	{
		m_MouseCapture = TRUE;
		ShowCursor(FALSE);
	}
	
	CView::OnLButtonDblClk(nFlags, point);
}

void COpenGLFrameworkView::Engine()
{
	// Handle mouse / keyboard input
	
	// Get a pointer to the document class
	COpenGLFrameworkDoc* pDoc = GetDocument();

	// Is the mouse captured ?
	if (m_MouseCapture == TRUE)
	{
		// Call camera actions based on mouse position
		if (m_Mouse.x != pDoc->m_ViewportWidth / 2)
		{
			// Mouse has been moved horizontal
			pDoc->m_Camera.RotateHorizontal(
				((pDoc->m_ViewportWidth / 2) - m_Mouse.x) / 7.0f);
		}
		if (m_Mouse.y != pDoc->m_ViewportHeight / 2)
		{
			// Mouse has been moved vertical
			pDoc->m_Camera.RotateVertical(
				((pDoc->m_ViewportHeight / 2) - m_Mouse.y) / 7.0f);
		}

		// Find screen coordinates of the crosshair
		POINT lMouseDest;
		lMouseDest.x = pDoc->m_ViewportWidth / 2;
		lMouseDest.y = pDoc->m_ViewportHeight / 2;
		ClientToScreen(&lMouseDest);

		// Move cursor over crosshair
		SetCursorPos(lMouseDest.x, lMouseDest.y);
	}

	// Test for certain keys and trigger the matching camera action

	// Is one of the movement keys down ?
	if( m_Keys[char('A')] == TRUE
		|| m_Keys[char('Y')] == TRUE
		|| m_Keys[char('Q')] == TRUE
		|| m_Keys[char('W')] == TRUE
		|| m_Keys[VK_LEFT] == TRUE
		|| m_Keys[VK_RIGHT] == TRUE
		|| m_Keys[VK_UP] == TRUE
		|| m_Keys[VK_DOWN] == TRUE)
	pDoc->m_Camera.Move(
		m_Keys[char('A')] == TRUE || m_Keys[VK_UP] == TRUE,
		m_Keys[char('Y')] == TRUE || m_Keys[VK_DOWN] == TRUE,
		m_Keys[char('Q')] == TRUE || m_Keys[VK_LEFT] == TRUE,
		m_Keys[char('W')] == TRUE || m_Keys[VK_RIGHT] == TRUE);

	// Is one of the look keys down ?
	if (m_Keys[VK_PRIOR] == TRUE)
		pDoc->m_Camera.RotateVertical(1.5f);
	if (m_Keys[VK_NEXT] == TRUE)
		pDoc->m_Camera.RotateVertical(-1.5f);
	if (m_Keys[VK_END] == TRUE)
		pDoc->m_Camera.CenterVertical();

	// Update window
	InvalidateRect(NULL, FALSE);
}


 
